/*
 * Decompiled with CFR 0.152.
 */
package ru.pinkgoosik.cosmetica.cosmetics.cloak;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ru.pinkgoosik.cosmetica.CosmeticaMod;
import ru.pinkgoosik.cosmetica.cosmetics.cloak.Cloak;
import ru.pinkgoosik.cosmetica.cosmetics.cloak.UniCloak;
import ru.pinkgoosik.cosmetica.render.cloak.CosmicCloakRenderer;
import ru.pinkgoosik.cosmetica.render.cloak.GlowingCloakRenderer;
import ru.pinkgoosik.cosmetica.render.cloak.JebCloakRenderer;
import ru.pinkgoosik.cosmetica.render.cloak.SwirlyCloakRenderer;

public class Cloaks {
    public static final List<Cloak> CLOAKS = new ArrayList<Cloak>();

    public static void init() {
        Cloaks.add(new UniCloak());
        Cloaks.addGrouped("colored", "azure", "crimson", "flamingo", "golden", "lapis", "military", "mint", "mystic", "pumpkin", "smoky", "turtle", "violet", "void", "coffee");
        Cloaks.addGrouped("pride", "pride", "trans", "lesbian", "gay", "pan", "bi", "non-binary", "genderfluid", "aromantic", "demiromantic", "asexual", "demisexual");
        Cloaks.addGrouped("patterned", "space");
        Cloaks.add(new Cloak("jeb", new JebCloakRenderer(false)));
        Cloaks.add(new Cloak("enchanted-jeb", new JebCloakRenderer(true)));
        Cloaks.add(new Cloak("cosmic", new CosmicCloakRenderer()));
        Cloaks.add(new Cloak("swirly", new SwirlyCloakRenderer()));
        Cloaks.add(new Cloak("glowing", new GlowingCloakRenderer()));
    }

    private static void addGrouped(String group, String ... names) {
        for (String name : names) {
            Cloaks.add(new Cloak(name, (player, world) -> CosmeticaMod.locate("textures/cloak/" + group + "/" + name + ".png")));
        }
    }

    private static void add(Cloak cloak) {
        CLOAKS.add(cloak);
    }

    public static Optional<Cloak> getCloak(String name) {
        for (Cloak cloak : CLOAKS) {
            if (!cloak.getName().equals(name)) continue;
            return Optional.of(cloak);
        }
        return Optional.empty();
    }
}

